{
    "use strict";

    var __plugin = 'destinationList';

    Ractive.decorators[__plugin] = function (
        node,
        postcodes_StartMarker_Internal,
        postcodeRange_Separator_Internal_Minimal,
        postcodeRange_Separator_Internal_Canonical,
        postcodeRange_Separator_Display
    ) {

        if (!postcodes_StartMarker_Internal ||
            !postcodeRange_Separator_Internal_Minimal ||
            !postcodeRange_Separator_Internal_Canonical ||
            !postcodeRange_Separator_Display
        ) {
            throw __plugin + ': missing one or more required parameters.';
        }

        var postcodeList_StartMarker_Display_Minimal = ':';
        var postcodeList_StartMarker_Display_Nice = postcodeList_StartMarker_Display_Minimal + ' ';

        var postcodeList_Separator_Internal = ',';
        var postcodeList_Separator_Display_Minimal = ',';
        var postcodeList_Separator_Display_Nice = postcodeList_Separator_Display_Minimal + ' ';

        var postcodeWildcard = '*';

        // noinspection JSUnresolvedVariable
        var $ = jQuery;

        /**
         * @param {string} string
         * @param {*} separator
         * @param {number} [limit]
         * @return {array}
         */
        var splitTrim = function(string, separator, limit) {
            return $.map(string.split(separator, limit), $.trim);
        };

        /**
         * @param {string} regex
         * @return {string}
         */
        var escapeRegEx = function (regex) {
            return regex.replace(/[\-\[\]\/{}()*+?.\\^$|]/g, "\\$&");
        };

        /**
         * @param {string} input
         * @param {*} token
         * @param {string} [canonicalToken]
         * @param {boolean} [removeTrailingAndLeading]
         * @param {boolean} [keepSpaces]
         * @return {string}
         */
        var canonize = function(input, token, canonicalToken, removeTrailingAndLeading, keepSpaces) {

            if (typeof(canonicalToken) === "undefined") {
                canonicalToken = token;
            }

            var spaces = (keepSpaces ? '' : '\\s*');
            var tokenRegex = '(' + spaces + escapeRegEx(token) + spaces + ')+';
            input = input.replace(new RegExp(tokenRegex, 'g'), canonicalToken);

            if (removeTrailingAndLeading) {
                input = input.replace(new RegExp('^' + tokenRegex + '|' + tokenRegex + '$', 'g'), '');
            }

            return input;
        };

        var replaceAll = function(input, search, replace) {
            return input.replace(new RegExp(escapeRegEx(search), 'g'), replace);
        };

        var removeAll = function(input, search) {
            return replaceAll(input, search, '');
        };

        {
            var keypath = node._ractive.binding.keypath.str;
            var value = this.get(keypath);

            $($.map($.isArray(value) ? value : [value], function (value) {

                var region, postcodes; {

                    var parts = value.split(postcodes_StartMarker_Internal);
                    if (parts.length !== 2) {
                        return null;
                    }

                    region = parts[0];
                    postcodes = parts[1];
                    if (!region || !postcodes) {
                        return null;
                    }
                }

                var title =
                    ($(node).find('[value="'+region+'"]').text() || region) +
                    postcodeList_StartMarker_Display_Nice +
                    splitTrim(postcodes, postcodeList_Separator_Display_Minimal).join(postcodeList_Separator_Display_Nice);

                var $option = $('<option>')
                    .text(title)
                    .attr('value', value)
                    .attr('selected', true);

                return $option[0];

            })).appendTo(node);
        }

        var select2Decorator;
        {
            var select2DecoratorPlugin = Ractive.decorators.select2;

            select2DecoratorPlugin.type[__plugin] = {
                tags: true,
                selectOnClose: true,
                closeOnSelect: true,
                language: {
                    'inputPostalCodes': function() {
                        return 'Type in zip/postal code(s)';
                    }
                },

                createTag: function (params) {

                    var parts = splitTrim(params.term, postcodeList_StartMarker_Display_Minimal, 2);
                    var region = parts[0];
                    var postcodes = parts[1];

                    var id = null;
                    if (region) {
                        this.$element.children().each(function() {
                            if ($(this).text() === region) {
                                id = $(this).attr('value') || region;
                                return false;
                            }
                        });
                    }

                    if (!id) {
                        return null;
                    }

                    var term = region;

                    if (postcodes) {
                        postcodes = $.map(postcodes.split(postcodeList_Separator_Internal), function(code) {

                            code = $.trim(code);

                            if (code.indexOf(postcodeRange_Separator_Internal_Minimal) !== -1) {
                                code = removeAll(code, postcodeWildcard);
                                code = canonize(code, postcodeRange_Separator_Internal_Minimal, postcodeRange_Separator_Internal_Canonical);
                                code = canonize(code, postcodeRange_Separator_Internal_Canonical, undefined, true);
                            }

                            code = canonize(code, postcodeWildcard, undefined, undefined, true);

                            return code === '' ? null : code;

                        }).join(postcodeList_Separator_Internal);
                    }

                    if (!postcodes) {
                        return null;
                    }

                    var postcodesDisplay = postcodes;
                    postcodesDisplay = replaceAll(postcodesDisplay, postcodeList_Separator_Internal, postcodeList_Separator_Display_Nice);
                    postcodesDisplay = replaceAll(postcodesDisplay, postcodeRange_Separator_Internal_Canonical, postcodeRange_Separator_Display);

                    id += postcodes_StartMarker_Internal + postcodes;
                    term += postcodeList_StartMarker_Display_Nice + postcodesDisplay;

                    return {
                        id: id,
                        text: term
                    };
                },

                templateSelection: function (d) {
                    return $(
                        '<span>' +
                            replaceAll(
                                d.text,
                                postcodeRange_Separator_Display,
                                '<span class="trs-postcode-range">' + postcodeRange_Separator_Display + '</span>'
                            ) +
                        '</span>'
                    );
                }
            };

            select2Decorator = select2DecoratorPlugin.call(this, node, __plugin);

            var select2Instance = $(node).data('select2');
            var $search = select2Instance.selection.$search;

            select2Instance.$container.on('click', '.select2-selection__choice', function() {

                var item = $(this).data('data');

                select2Instance.trigger('unselect', {data: item});

                $search.val(
                    item.text.indexOf(postcodeList_StartMarker_Display_Nice) === -1
                        ?
                            item.text.replace(
                                new RegExp('(' + escapeRegEx(postcodeList_StartMarker_Display_Minimal) + ')+\\s*$'),
                                ''
                            ) +
                            postcodeList_StartMarker_Display_Nice
                        :
                            item.text
                );

                $search.css('width', (($search.val().length + 1) * 0.75) + 'em');
                select2Instance.trigger('query', {term: $search.val()});
            });

            select2Instance.on('results:message', function(params) {
                if (params.message === 'noResults') {
                    var marker = postcodeList_StartMarker_Display_Minimal;
                    var endsWithMarker = $.trim($search.val()).substr(-marker.length) === marker;
                    if (endsWithMarker) {
                        this.trigger('results:message', {
                            message: 'inputPostalCodes'
                        });
                    }
                }
            });
        }

        return {
            teardown: function () {
                if (select2Decorator) {
                    select2Decorator.teardown();
                    select2Decorator = null;
                }
            }
        };
    };
}