<?php
namespace Trs\Migration;

use Trs\Migration\Interfaces\IConfigMigration;
use Trs\Migration\Interfaces\IMigration;
use Trs\Migration\Interfaces\IPerRuleMigration;
use Trs\Migration\Storage\IStorage;


class UberMigration implements IMigration
{
    /**
     * @param IMigration[]|IConfigMigration[]|IPerRuleMigration[] $migrations  Mixed list of specified interfaces.
     * @param string $migratingFromVersion
     */
    public function __construct(array $migrations, $migratingFromVersion)
    {
        $this->migrations = $migrations;
        $this->migratingFromVersion = $migratingFromVersion;
    }

    public function migrate(IStorage $storage, $time = null)
    {
        if (empty($this->migrations)) {
            return;
        }

        if (!isset($time)) {
            $time = time();
        }


        $configKeys = $storage->findKeysLike('woocommerce\\_tree\\_table\\_rate\\_%settings');

        foreach ($configKeys as $key) {

            $bkpKey = null; {
                $idx = 1;
                do {
                    $bkpKey = "{$key}__bkp_{$this->migratingFromVersion}_{$idx}";
                    $idx++;
                } while ($storage->get($bkpKey, false) !== false);
            }

            $storage->set($bkpKey, json_encode(array(
                'time' => $time,
                'time_utc' => gmdate('Y-m-d H:i:s', $time),
                'config' => $storage->get($key),
            )), false);
        }

        foreach ($configKeys as $key) {

            $config = $storage->get($key);
            $config['rule'] = json_decode($config['rule'], true);

            foreach ($this->migrations as $migration) {

                if ($migration instanceof IPerRuleMigration) {
                    self::visitRulesRecursively($config['rule'], function (&$rule) use ($migration) {
                        $migration->migrateRule($rule);
                    });
                }

                if ($migration instanceof IConfigMigration) {
                    $migration->migrateConfig($config);
                }
            }

            $config['rule'] = json_encode($config['rule']);
            $storage->set($key, $config);
        }

        foreach ($this->migrations as $migration) {
            if ($migration instanceof IMigration) {
                $migration->migrate($storage);
            }
        }
    }

    private $migrations;
    private $migratingFromVersion;

    static private function visitRulesRecursively(array &$rule, $callback)
    {
        $callback($rule);

        if (!empty($rule['children'])) {
            foreach ($rule['children'] as &$child) {
                self::visitRulesRecursively($child, $callback);
            }
        }
    }
}
