<?php
namespace Dgm\Comparator\Tests;

use Dgm\Comparator\NumberComparator;
use Dgm\Comparator\StringComparator;
use InvalidArgumentException;
use PHPUnit_Framework_TestCase;


class StringComparatorTest extends PHPUnit_Framework_TestCase
{
    /** @dataProvider compareTests */
    public function testCompare($a, $b, $operator)
    {
        $comparator = new StringComparator();
        $this->assertTrue($comparator->compare($a, $b, $operator));
    }

    /** @dataProvider nonScalars */
    public function testFailsOnNonScalars($value)
    {
        $comparator = new StringComparator();
        $this->expectException(InvalidArgumentException::class);
        $comparator->compare($value, $value);
    }

    static public function compareTests()
    {
        return [
            ['a', 'b', '<'],
            ['a', 'b', '<='],
            ['b', 'b', '<='],
            ['012', '1.2', '<'],
        ];
    }

    static public function nonScalars()
    {
        return [
            [[]],
            [new \stdClass()],
            [null],
        ];
    }
}